// Copy Objects Along To.js
//
// place it into ( ~/Library/Application Support/Cheetah3D/scripts/Tool folder ).

var RAD = 180/Math.PI;

var Vec3D_len = function() {
    if( arguments.length == 1)
        return Math.sqrt( arguments[0].x*arguments[0].x + arguments[0].y*arguments[0].y + arguments[0].z*arguments[0].z );
    var p = arguments[1].sub(arguments[0]);
    return Math.sqrt( p.x*p.x + p.y*p.y + p.z*p.z );
}

var Vec3D_normalize = function() {
        var l = arguments[0].norm();
        if( l != 0) 
            return arguments[0].multiply(1/l);
        return arguments[0];
}

function buildUI( tool ) {
    
    tool.addParameterSeparator("Copy Objects");
    
    tool.addParameterLink("along to", false);
    
    tool.addParameterInt("count", 4, 1, 1000, false, false);
    tool.addParameterBool("make as hierarchical", 1, 0, 1, false, false);
    
    tool.addParameterButton("copy", "copy", "copyObjects");
}

var splHolder = new Array;
var splList = new Array;

function copyObjects( tool ) {
    
    var path = tool.getParameter("along to");
    
    if (! path || path.family() != SPLINEFAMILY) return;
    
    var count = tool.getParameter("count");
    var hier = tool.getParameter("make as hierarchical");
    
    var doc = tool.document();
    var obj = doc.selectedObject();
    
    var pcore = path.modCore();
    var pmat = path.objMatrix();
    
    var pathCount = pcore.pathCount();
    var i, j;
    
    for (i = 0;i < pathCount;i++) {
        splHolder = pcore.cache(i);
        if (!splHolder) break;
        cacheSplineLength();
        var totalLength = calcSplineLength( splHolder, splList );
        var baseMat = new Mat4D();
        var baseRot = new Vec3D();
        var copyParent = undefined;
        
        for (j = 0;j < count;j++) {
            
            var copy = doc.addObject( obj.type() );
            
            copy.setParameter("name", obj.getParameter("name") + '_' + j );
            var vec = pointFromPercentage( j / (count-1), pmat );
            var asy = asyVecFromPercentage( j / (count-1), pmat, 0.01 );
            
            var theta = Math.acos( asy.y )*RAD;
            var phi = Math.atan2( asy.x, asy.z )*RAD;
            
            vec = baseMat.multiply( vec );
            copy.setParameter("position", vec);
            
            copyMat = copy.objMatrix();
            
            if (hier) {
                if (copyParent) {
                    copyParent.addChildAtIndex( copy, 0 );
                }
                
                copyParent = copy;
                baseMat = baseMat.multiply( copyMat.inverse() );
            }
        }
    }
}

// these functions from Todd's Loft.js script.
// thank you for sharing, Todd. :D
function calcSplineLength(points,lst) {
	var l = points.length;
	var i;
	var accum = 0;
	lst[0] = 0;
	for(i=0;i<l-1;i++) {
		var p = points[i+1].sub(points[i]);
		accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
		lst[i+1] = accum;
	}
	for(i=0;i<l;i++) {
		lst[i] = lst[i]/accum;
	}
	return accum;
}

function pointFromPercentage(percent, mat) { // these spline stuff from Todd's Loft.js
    if (percent < 0 && percent > 1) return new Vec3D(0,0,0);
    var i; var hi = splHolder.length - 1; var lo = 0;
    var d = percent;
    while (hi - lo > 1) {
        i = Math.floor((hi+lo)/2);
        if (percent <= splList[i]) {
            hi = i;
            continue;
        }
        if (percent > splList[i]) {
            lo = i;
        }
    }
    i = hi;
    
    var p1 = splHolder[i-1];
    var p2 = splHolder[i];
    //
    d = (d - splList[i-1])/(splList[i] - splList[i-1]);
    p1 = p1.multiply(1-d).add(p2.multiply(d));
    return mat.multiply(p1);
}

function asyVecFromPercentage(percent, mat, m) {
    if (1-m > percent) {
        var prePer = percent - m;
        var posPer = percent;
    } else if (m > percent) {
        var prePer = 0;
        var posPer = percent + m;
    } else {
        var prePer = percent - m;
        var posPer = percent + m;
    }
    prePos = pointFromPercentage( prePer, mat );
    posPos = pointFromPercentage( posPer, mat );
    
    var asyVec = posPos.sub(prePos);
    var norm = asyVec.norm();
    
    return (norm == 0)? asyVec.multiply(0) : asyVec.multiply( 1/norm ) ;
}

function cacheSplineLength() {
    var l = splHolder.length;
    var i;

    var accum = 0;
    splList[0] = 0;
    for (i = 0;i < l - 1;i++) {
        var p = splHolder[i+1].sub(splHolder[i]);
        accum = accum + Math.sqrt( p.x * p.x + p.y * p.y + p.z * p.z);
        splList[i+1] = accum;
    }
    for (i = 0;i < l;i++) {
        splList[i] = splList[i] / accum;
    }
}
